﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using PsgBase;
using PsgIntl;

namespace Shippers
{
    [EditorClass, ViewGrid]
    public partial class Shippers : Base
    {
        #region Members
        ShippersBE.ShippersDataTable table = new ShippersBE.ShippersDataTable();
        ShippersBE.ShippersRow rowA = null;
        #endregion

        #region Constructors

        public Shippers()
        {
            InitializeComponent();
        }

        public Shippers(ViewGrid _browser)
            : base(_browser)
        {
            InitializeComponent();
        }

        public Shippers(LookupGrid _search)
            : base(_search)
        {
            InitializeComponent();
        }

        #endregion Constructors

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "shipperid";
            context.PsgFieldDisplay = "companyname";
            context.PsgCommand = "shippers";
            context.PsgServerTableName = "shippers";
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddTable("Shippers", ID, "C");
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);

            switch (this.alias_name.ToUpper())
            {
                case "SHIPPERS":
                    table = (ShippersBE.ShippersDataTable)SetMainData(dt, table);
                    rowA = (ShippersBE.ShippersRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edShipper, table.companynameColumn);
            BindEdit(edPhone, table.phoneColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.companynameColumn, GetIntl(Intl.Shipper), 200);
            this.ColumnsView(table.phoneColumn, GetIntl(Intl.Phone_numbers), 150);

            this.FiltersView(table.companynameColumn, GetIntl(Intl.Shipper));
            this.FiltersView(table.phoneColumn, GetIntl(Intl.Phone_numbers));
        }
    }
}
